within ;
model SimpleTransmissionTestBench

  Modelica.Blocks.Sources.Ramp ramp(height=100, duration=20)
    annotation (Placement(transformation(extent={{-90,30},{-70,50}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{-46,28},{-26,48}})));
  Modelica.Mechanics.Rotational.Components.Damper damper1(d=0.05)
    annotation (Placement(transformation(extent={{64,30},{84,50}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{80,-4},{100,16}})));
  SimpleTransmission simpleTransmission
    annotation (Placement(transformation(extent={{-6,26},{14,46}})));
  Modelica.Blocks.Sources.TimeTable timeTable(table=[0,1; 10,1; 10.1,2; 1000,2])
    annotation (Placement(transformation(extent={{-30,62},{-10,82}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=10)
    annotation (Placement(transformation(extent={{30,30},{50,50}})));
equation

  connect(ramp.y, torque.tau) annotation (Line(
      points={{-69,40},{-58,40},{-58,38},{-48,38}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(torque.flange, simpleTransmission.flange_a) annotation (Line(
      points={{-26,38},{-14,38},{-14,40.6},{-3.6,40.6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper1.flange_b, fixed.flange) annotation (Line(
      points={{84,40},{90,40},{90,6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(timeTable.y, simpleTransmission.u1) annotation (Line(
      points={{-9,72},{-2,72},{-2,43.4},{3.8,43.4}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(inertia.flange_b, damper1.flange_a) annotation (Line(
      points={{50,40},{64,40}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(simpleTransmission.flange_b, inertia.flange_a) annotation (Line(
      points={{11,40.6},{21.5,40.6},{21.5,40},{30,40}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Diagram(graphics));
end SimpleTransmissionTestBench;
